<?php
require_once "functions.php";
$records = getAllQuizSessions(); 

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // fetch winners list for session
    if (isset($_POST['fetch_winners'])) {
        $sessionId = intval($_POST['session_id']);
        $winners = getQuestionWinnersBySession($sessionId);
        header('Content-Type: application/json');
        echo json_encode($winners);
        exit; // 👈 very important, stop further HTML
    }
    if (isset($_POST['fetch_question_answers'])) {
    $quizId = intval($_POST['quiz_id']);
    $questionId = intval($_POST['question_id']);
    $quizRecordId = intval($_POST['quiz_record_id']);

    $answers = getAnswersForQuestion($quizId, $questionId, $quizRecordId);
    header('Content-Type: application/json');
    echo json_encode($answers);
    exit;
}

}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="./css/style.css">
    <style>
        .correct { color: green; font-weight: bold; }
        .wrong { color: red; font-weight: bold; }
    </style>
</head>
<body>
    <h3 style="margin-left:1%">Quiz Sessions</h3>
    <div style="margin:1% 1%;">
        <input class="custom-input" type="text" id="searchSession" placeholder="Search Session Id">
        <input class="custom-input" type="text" id="searchLive" placeholder="Search Live Id">
        <input class="custom-input" type="text" id="searchQuiz" placeholder="Search Quiz Id">
        <input class="custom-input" type="text" id="searchCategory" placeholder="Search Category">
        <input class="custom-input" type="text" id="searchLanguage" placeholder="Search Language">
        <button type="button" style="padding:1%" class="button-add-admin" onclick="clearFilters()"><span>Reset</span></button>
        
    </div>
    <div class="table-wrapper" style="margin-top:1%">
        <table id="quizTable" border="1" cellpadding="10" cellspacing="0">

            <thead>
                <tr>
                    <th>Session Id</th>
                    <th>Live Id</th>
                    <th>Quiz Id</th>
                    <th>Start Time</th>
                    <th>End Time</th>
                    <th>Started By</th>
                    <th>Category</th>
                    <th>Language</th>
                    <th>No of Questions</th>
                    <th>Winner Id</th>
                    <th class="sticky-col" style="background-color:white;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($records)): ?>
                    <?php foreach ($records as $r): ?>
                        <tr>
                            <td><?= $r['session_id'] ?></td>
                            <td><?= $r['live_id'] ?></td>
                            <td><?= $r['quiz_id'] ?></td>
                            <td><?= $r['session_start'] ?></td>
                            <td><?= $r['session_end'] ?></td>
                            <td><?= htmlspecialchars($r['started_by_user']) ?> / <?= $r['started_by_user_id'] ?></td>
                            <td><?= htmlspecialchars($r['category']) ?></td>
                            <td><?= htmlspecialchars($r['language']) ?></td>
                            <td><?= htmlspecialchars($r['no_questions']) ?></td>
                            <td><?= $r['winner_id'] ?></td>
                            <td class="sticky-col" style="background-color:#f0efff;">
                                <a href="#" onclick='openAnswerModal(<?= json_encode($r) ?>); return false;'>
                                    <img src="./icons/view.png" alt="View Answers" style="width:18px; height:18px;">
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="10">No quiz sessions found</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- View Quiz Answers -->
    <div id="answerModal" 
        style="display:none; position:fixed; top:10%; left:50%; transform:translateX(-50%); width:70%; max-width:700px; background:white; padding:20px; border:1px solid #ccc; box-shadow:0 0 10px rgba(0,0,0,0.2); border-radius:8px; overflow-y:auto; max-height:80vh; z-index:1000;">

        <!-- Close Button -->
        <button type="button" onclick="closeModal()" 
            style="position:absolute; top:10px; right:10px; background:none; border:none;font-size:20px; font-weight:bold; cursor:pointer;">&times;</button>
        
        <h3 style="display:flex; justify-content:center; margin-top:2%; padding-bottom:4%">
            Question Winners (Session <span id="answerSessionId"></span>)
        </h3>

        <!-- Winners Table -->
        <div style="border:1px solid #ccc; padding:10px; border-radius:5px; margin-top:10px;">
            <table border="1" cellpadding="8" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th>Question ID</th>
                        <th>Winner (Name / ID)</th>
                        <th>Time (ms)</th>
                        <th>Created At</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody id="answerTableBody">
                    <tr><td colspan="4">No data</td></tr>
                </tbody>
            </table>
        </div>
        
    </div>
    <!-- User Answer Modal -->
    <div id="userAnswerModal" 
        style="display:none; position:fixed; top:10%; left:50%; transform:translateX(-50%);
            width:70%; max-width:800px; background:white; padding:20px; border:1px solid #ccc;
            box-shadow:0 0 10px rgba(0,0,0,0.2); border-radius:8px; overflow-y:auto; max-height:80vh; z-index:1000;">

        <button type="button" onclick="closeModalSecond()" 
            style="position:absolute; top:10px; right:10px; background:none; border:none;
                font-size:20px; font-weight:bold; cursor:pointer;">&times;</button>

        <h3 style="text-align:center; margin-bottom:20px;">All Answers</h3>

        <table border="1" cellpadding="8" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>User</th>
                    <th>Question</th>
                    <th>Answer</th>
                    <th>Status</th>
                    <th>Time Taken (ms)</th>
                    <th>Answered At</th>
                </tr>
            </thead>
            <tbody id="userAnswerTableBody">
                <tr><td colspan="6">No data</td></tr>
            </tbody>
        </table>
    </div>

    <script src="./js/script_user.js" defer></script>
    <script>
     //search filter code   
    const filters = {
        session: document.getElementById("searchSession"),
        live: document.getElementById("searchLive"),
        quiz: document.getElementById("searchQuiz"),
        category: document.getElementById("searchCategory"),
        language: document.getElementById("searchLanguage"),
    };

    Object.values(filters).forEach(input => {
        input.addEventListener("keyup", filterTable);
    });

    function filterTable() {
        const table = document.getElementById("quizTable");
        const trs = table.querySelectorAll("tbody tr");

        trs.forEach(tr => {
        const tdSession = tr.cells[0].textContent.toLowerCase();
        const tdLive    = tr.cells[1].textContent.toLowerCase();
        const tdQuiz    = tr.cells[2].textContent.toLowerCase();
        const tdCat     = tr.cells[6].textContent.toLowerCase();
        const tdLang    = tr.cells[7].textContent.toLowerCase();

        const match =
            tdSession.includes(filters.session.value.toLowerCase()) &&
            tdLive.includes(filters.live.value.toLowerCase()) &&
            tdQuiz.includes(filters.quiz.value.toLowerCase()) &&
            tdCat.includes(filters.category.value.toLowerCase()) &&
            tdLang.includes(filters.language.value.toLowerCase());

        tr.style.display = match ? "" : "none";
        });
    }

    function clearFilters() {
        Object.values(filters).forEach(input => input.value = "");
        filterTable();
    }
</script>
</body>
</html>