<?php
require_once "functions.php";
if (isset($_GET['msg'])) {
    switch ($_GET['msg']) {
        case 'add_quiz_success':
            $message = "✅ New Quiz added successfully!";
            $messageType = "success";
            break;
        case 'add_quiz_error':
            $message = "❌ Failed to add new Quiz.";
            $messageType = "error";
            break;  
        case 'edit_quiz_success':
            $message = "✅ Quiz Edited successfully!";
            $messageType = "success";
            break;
        case 'edit_quiz_error':
            $message = "❌ Failed to Edit the QUIZ.";
            $messageType = "error";
            break;
        case 'quiz_updated':
            $message = "✅ Quiz updated successfully!";
            $messageType = "success";
            break;
        case 'quiz_update_error':
            $message = "❌ Failed to update Quiz.";
            $messageType = "error";
            break;    
        case 'add_question_success':
            $message = "🗑️ Question added successfully!";
            $messageType = "success";
            break;
        case 'add_question_error':
            $message = "❌ Failed to new question.";
            $messageType = "error";
            break;
                       
        default:
            $message = '';
            $messageType = '';
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' ) {
    //view user detals
    if (isset($_POST['fetch_answers'])){
        $sessionId = intval($_POST['session_id']);
        $answers = getAnswersByRecord($sessionId);
        header('Content-Type: application/json');
        echo json_encode($answers);
        exit;
    }
   // Add quiz
    if (isset($_POST['add_new_quiz'])) {
        $data = [
            'name' => $_POST['name'],  // <-- added
            'question_text' => $_POST['question_text'],
            'answer_type' => $_POST['answer_type'],
            'options' => $_POST['options'],
            'correct_answer' => $_POST['correct_answer'],
        ];
        if (addQuiz($conn, $data)) {
            header("Location: quiz_index.php?msg=add_quiz_success");
            exit;
        }else {
            header("Location: quiz_index.php?msg=add_quiz_error");
            exit;
        }
    }
    // Fetch only questions (for viewing)
    if (isset($_POST['fetch_questions'])) {
        $quizId = intval($_POST['quiz_id']);
        $questions = getQuestionsByQuiz($quizId);
        header('Content-Type: application/json');
        echo json_encode($questions);
        exit;
    }
    // Fetch full quiz (for editing)
    if (isset($_POST['fetch_full_quiz'])) {
        $quizId = intval($_POST['quiz_id']);
        $quiz = getQuizById($quizId);
        header('Content-Type: application/json');
        echo json_encode($quiz);
        exit;
    }
    // Edit quiz
    if (isset($_POST['edit_id'])) {
        $data = [
            'id' => intval($_POST['edit_id']),
            'question_text' => $_POST['question_text'],
            'answer_type' => $_POST['answer_type'],
            'options' => $_POST['options'],
            'correct_answer' => $_POST['correct_answer'],
        ];
        if (updateQuiz($conn, $data)) {
            header("Location: quiz_index.php?msg=edit_quiz_success");
            exit;
        }else {
            header("Location: quiz_index.php?msg=edit_quiz_error");
            exit;
        }
    }
    if (isset($_POST['update_quiz_all'])) {
        $quizId = intval($_POST['quiz_id']);
        $updateSuccess = true; // Flag to track if everything succeeds

        // Update quiz info
        $sql = "UPDATE bogo_quiz_quizzes
                SET category_id = ?, language_id = ?, updated_at = NOW()
                WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iii", $_POST['category_id'],$_POST['language_id'], $quizId);
        if (!$stmt->execute()) {
            $updateSuccess = false;
        }

        // Update questions
        foreach ($_POST['questions'] as $qid => $qData) {
            $sql2 = "UPDATE bogo_quiz_questions
                    SET question_text = ?, answer_type = ?, options = ?, correct_answer = ?
                    WHERE id = ? AND quiz_id = ?";
            $stmt2 = $conn->prepare($sql2);

            $options = !empty($qData['options']) ? json_encode(explode(',', $qData['options'])) : json_encode([]);

            $stmt2->bind_param("ssssii",
                $qData['text'],
                $qData['type'],
                $options,
                $qData['answer'],
                $qid,
                $quizId
            );

            if (!$stmt2->execute()) {
                $updateSuccess = false;
            }
        }

        // Redirect based on success or failure
        if ($updateSuccess) {
            header("Location: quiz_index.php?msg=quiz_updated");
        } else {
            header("Location: quiz_index.php?msg=quiz_update_error");
        }
        exit;
    }

    if (isset($_POST['delete_question_id'])) {
        $questionId = intval($_POST['delete_question_id']);
        $quizId = intval($_POST['quiz_id']);

        $stmt = $conn->prepare("DELETE FROM bogo_quiz_questions WHERE id = ? AND quiz_id = ?");
        $stmt->bind_param("ii", $questionId, $quizId);
        $success = $stmt->execute();

        header('Content-Type: application/json');
        echo json_encode([
            'success' => $success,
            'quiz' => getQuizById($quizId) // return updated quiz to re-render table
        ]);
        exit;
    }// Add new questions from View modal
    if (isset($_POST) && !empty(file_get_contents("php://input"))) {
        $input = json_decode(file_get_contents("php://input"), true);
        if (!empty($input['new_questions']) && !empty($input['quiz_id'])) {
            $quizId = intval($input['quiz_id']);
            $success = true;

            foreach ($input['new_questions'] as $q) {
                $options = !empty($q['options']) ? json_encode(explode(',', $q['options'])) : json_encode([]);
                $stmt = $conn->prepare("INSERT INTO bogo_quiz_questions (quiz_id, question_text, answer_type, options, correct_answer) VALUES (?, ?, ?, ?, ?)");
                $stmt->bind_param("issss", $quizId, $q['text'], $q['type'], $options, $q['answer']);
                if (!$stmt->execute()) {
                    $success = false;
                }
            }

            header('Content-Type: application/json');
            echo json_encode(['success' => $success]);
            exit;
        }
        if (isset($input['new_category'])) {
            $name = trim($input['new_category']);
            if ($name === '') {
                echo json_encode(['success' => false, 'error' => 'Empty category name']);
                exit;
            }

            // Check if category exists
            $stmt = $conn->prepare("SELECT id FROM bogo_quiz_categories WHERE name = ?");
            $stmt->bind_param("s", $name);
            $stmt->execute();
            $stmt->store_result();
            if ($stmt->num_rows > 0) {
                echo json_encode(['success' => false, 'error' => 'Category already exists']);
                exit;
            }

            // Insert new category
            $stmt = $conn->prepare("INSERT INTO bogo_quiz_categories (name) VALUES (?)");
            $stmt->bind_param("s", $name);
            $stmt->execute();
            $id = $conn->insert_id;

            echo json_encode(['success' => true, 'id' => $id, 'name' => $name]);
            exit;
        }
        if (isset($input['new_language'])) {
            $name = trim($input['new_language']);
            if ($name === '') {
                echo json_encode(['success' => false, 'error' => 'Empty language name']);
                exit;
            }

            // Check if category exists
            $stmt = $conn->prepare("SELECT id FROM bogo_quiz_language WHERE name = ?");
            $stmt->bind_param("s", $name);
            $stmt->execute();
            $stmt->store_result();
            if ($stmt->num_rows > 0) {
                echo json_encode(['success' => false, 'error' => 'language already exists']);
                exit;
            }

            // Insert new category
            $stmt = $conn->prepare("INSERT INTO bogo_quiz_language (name) VALUES (?)");
            $stmt->bind_param("s", $name);
            $stmt->execute();
            $id = $conn->insert_id;

            echo json_encode(['success' => true, 'id' => $id, 'name' => $name]);
            exit;
        }
    }
    if (isset($_POST['questions']) && isset($_POST['category_id'])) {
        $categoryId = intval($_POST['category_id']);
        $languageId = intval($_POST['language_id']);
        $insertSuccess = true; // Flag to track success
        $quizName = trim($_POST['name']);
        // Insert quiz
        $stmt = $conn->prepare("INSERT INTO bogo_quiz_quizzes (name,category_id, language_id, created_at, updated_at) VALUES (?, ?, ?, NOW(), NOW())");
        $stmt->bind_param("sii", $quizName, $categoryId, $languageId);
        if (!$stmt->execute()) {
            $insertSuccess = false;
        }
        $quizId = $conn->insert_id;

        // Insert questions
        foreach ($_POST['questions'] as $q) {
            $options = !empty($q['options']) ? json_encode(explode(',', $q['options'])) : json_encode([]);
            $stmt2 = $conn->prepare("INSERT INTO bogo_quiz_questions (quiz_id, question_text, answer_type, options, correct_answer) VALUES (?, ?, ?, ?, ?)");
            $stmt2->bind_param("issss", $quizId, $q['text'], $q['type'], $options, $q['answer']);
            if (!$stmt2->execute()) {
                $insertSuccess = false;
            }
        }

        // Redirect based on success or failure
        if ($insertSuccess) {
            header("Location: quiz_index.php?msg=add_question_success");
        } else {
            header("Location: quiz_index.php?msg=add_question_error");
        }
        exit;
    }

}
$quizzes = getAllQuizzes();
//$records = getAllQuizRecords();
$categories = getAllCategories();
$languages = getAlllanguages();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Quiz Dashboard</title>
    <link rel="stylesheet" href="./css/style.css">
    <style>
        .correct { color: green; font-weight: bold; }
        .wrong { color: red; font-weight: bold; }
    </style>
</head>
<body>
    <div id="alertBox" 
        style="
            display: none;
            padding: 15px;
            margin: 20px;
            font-weight: bold;
            border-radius: 5px;
            text-align: center;
            position: fixed;
            top: 10px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 9999;
        ">
    </div>
    <h2 style="text-align:center;">Quiz Dashboard</h2>
    <div style=" display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
        <!-- Category Toggle -->
        <label class="switch">
        <input type="checkbox" onclick="toggleDiv('addCategoryDiv')">
        <span class="slider"></span>
        <span class="label-text">Category</span>
        </label>
        <!-- Language Toggle -->
        <label class="switch">
        <input type="checkbox" onclick="toggleDiv('addLanguageDiv')">
        <span class="slider"></span>
        <span class="label-text">Language</span>
        </label>
        <button type="button" onclick="openAddQuizModal()" 
            class="button-add-admin" style="margin-right:0.5%;">
            <span>
                <svg
                    height="18"
                    width="18"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg">
                    <path d="M0 0h24v24H0z" fill="none"></path>
                    <path d="M11 11V5h2v6h6v2h-6v6h-2v-6H5v-2z" fill="currentColor"></path>
                </svg>
                quiz
            </span>
        </button>
    </div>
    <!-- Add new Category Form (hidden by default) -->
    <div id="addCategoryDiv" style="display:none; margin:20px 0; padding:15px; border:1px solid #ccc; border-radius:8px; max-width:400px;margin-left:30%;">
        <h4>Add New Category</h4>
        <input type="text" id="newCategoryName" placeholder="Category Name" class="custom-input" style="width:80%;">
        <button type="button" id="saveCategoryBtn"><span>Add</span></button>
        <div id="categoryMessage" style="margin-top:10px;"></div>
    </div>
    <!-- Add new Language Form (hidden by default) -->
    <div id="addLanguageDiv" style="display:none; margin:20px 0; padding:15px; border:1px solid #ccc; border-radius:8px; max-width:400px;margin-left:30%;">
        <h4>Add New Language</h4>
        <input type="text" id="newlanguageName" placeholder="Language Name" class="custom-input" style="width:80%;">
        <button type="button" id="savelanguageBtn"><span>Add</span></button>
        <div id="languageMessage" style="margin-top:10px;"></div>
    </div>
    <h3 style="margin-left:1%">All Quizzes</h3>
    <div class="table-wrapper" style="margin-top:1%">
        <table border="1" cellpadding="10" cellspacing="0">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Category</th>
                    <th>language</th>
                    <th>No. of Questions</th>
                    <th>created At</th>
                    <th>Updated At</th>
                    <th class="sticky-col" style="background-color:white;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($quizzes)): ?>
                    <?php foreach ($quizzes as $q): ?>
                        <tr>
                            <td><?= $q['id'] ?></td>
                            <td><?= htmlspecialchars($q['name']) ?></td>
                            <td><?= htmlspecialchars($q['category_name']) ?></td>
                            <td><?= htmlspecialchars($q['language_name']) ?></td>
                            <td><?= $q['question_count'] ?></td>
                            <td><?= htmlspecialchars($q['created_at']) ?></td>
                            <td><?= htmlspecialchars($q['updated_at']) ?></td>
                            <td class="sticky-col" style="background-color:#f0efff;">
                                <a href="#" onclick='openQuestinoModal(<?= json_encode($q) ?>); return false;'>
                                    <img src="./icons/view.png" alt="View Answers" style="width:18px; height:18px;">
                                </a>
                                <a href="#" onclick='openEditQuiz(<?= json_encode($q) ?>); return false;'>
                                    <img src="./icons/edit.png" alt="Edit" style="width:18px; height:18px;">
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="5">No quizzes found</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>    
    <!-- Edit Quiz Modal -->
    <div id="editQuizModal" style="display:none; position:fixed; top:10%; left:50%; transform:translateX(-50%); width:75%; max-width:900px; background:white; padding:20px; border:1px solid #ccc; box-shadow:0 0 10px rgba(0,0,0,0.2); border-radius:8px; overflow-y:auto; max-height:85vh;">
        <button type="button" onclick="closeModal()" style="position:absolute; top:10px; right:10px; background:none; border:none; font-size:20px; font-weight:bold; cursor:pointer;">&times;</button>
        <h3 style="text-align:center; margin-top:2%; padding-bottom:4%">Edit Quiz</h3>
        <form method="post">
            <input type="hidden" name="quiz_id" id="edit_quiz_id">
            <label>Category:
                <select name="category_id" id="edit_quiz_category" class="custom-input" required>
                    <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </label><br><br>
            <label>Language:
                <select name="language_id" id="edit_quiz_language" class="custom-input" required>
                    <?php foreach ($languages as $lan): ?>
                    <option value="<?= $lan['id'] ?>"><?= htmlspecialchars($lan['name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </label><br><br>
            <h4>Questions</h4>
            <div id="editQuestionsList"></div>

            <button type="submit" name="update_quiz_all" class="button-add-admin" style="color:white;">Update Quiz</button>
        </form>
    </div>
    <!-- View Quiz Modal -->
    <div id="viewQuestionsModal" style="display:none; position:fixed; top:10%; left:50%; transform:translateX(-50%); width:70%; max-width:800px; background:white; padding:20px; border:1px solid #ccc; box-shadow:0 0 10px rgba(0,0,0,0.2); border-radius:8px; overflow-y:auto; max-height:80vh;">
        <button type="button" onclick="closeModal()" style="position:absolute; top:10px; right:10px; background:none; border:none; font-size:20px; font-weight:bold; cursor:pointer;">&times;</button>        
        <h3 style="text-align:center; margin-top:2%; padding-bottom:4%">Quiz Questions</h3>
        <!-- Add New Question Button -->
        <button type="button" id="addQuestionViewBtn" style="margin-bottom:10px;" style="color:white;"><span>
                <svg
                    height="18"
                    width="18"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg">
                    <path d="M0 0h24v24H0z" fill="none"></path>
                    <path d="M11 11V5h2v6h6v2h-6v6h-2v-6H5v-2z" fill="currentColor"></path>
                </svg>
                Question
            </span>
        </button>
        <table border="1" width="100%" cellpadding="8" cellspacing="0" style="border-collapse:collapse; text-align:left;">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Question</th>
                    <th>Answer Type</th>
                    <th>Options</th>
                    <th>Correct Answer</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody id="questionsTableBody"></tbody>
        </table>
    </div>
    <!-- Add Quiz Modal -->
    <div id="addQuizModal" style="display:none; position:fixed; top:10%; left:50%; transform:translateX(-50%); width:75%; max-width:900px; background:white; padding:20px; border:1px solid #ccc; box-shadow:0 0 10px rgba(0,0,0,0.2); border-radius:8px; overflow-y:auto; max-height:85vh;">
        <button type="button" onclick="closeModal()" style="position:absolute; top:10px; right:10px; background:none; border:none; font-size:20px; font-weight:bold; cursor:pointer;">&times;</button>
        <h3 style="text-align:center; margin-top:2%; padding-bottom:4%" style="color:white;">Add New Quiz</h3>
        <form id="addQuizForm" method="post">
            <label>Quiz Name:
                <input type="text" name="name" id="quiz_name" class="custom-input" required placeholder="Enter quiz name">
            </label><br><br>
            <label>Category:
                <select name="category_id" id="add_quiz_category" class="custom-input" required>
                    <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </label><br><br>
            <label>language:
                <select name="language_id" id="add_quiz_language" class="custom-input" required>
                    <?php foreach ($languages as $lan): ?>
                    <option value="<?= $lan['id'] ?>"><?= htmlspecialchars($lan['name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </label><br><br>
            <h4>Questions</h4>
            <div id="addQuestionsList"></div>
            <button type="button" id="addNewQuestionBtn" style="margin-bottom:10px;">Add            
            </span></button><br>
            <button type="submit" class="button-add-admin"><span>
                <svg
                    height="18"
                    width="18"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg">
                    <path d="M0 0h24v24H0z" fill="none"></path>
                    <path d="M11 11V5h2v6h6v2h-6v6h-2v-6H5v-2z" fill="currentColor"></path>
                </svg>
                submit
            </span></button>
        </form>
    </div>   
<script src="./js/script.js" defer></script>  
<script>
    <?php if (!empty($message)): ?>
        // Display alert dynamically
        const alertBox = document.getElementById("alertBox");
        alertBox.textContent = <?= json_encode($message) ?>;
        alertBox.style.display = "block";
        alertBox.style.backgroundColor = <?= $messageType === 'success' ? '"#d4edda"' : '"#f8d7da"' ?>;
        alertBox.style.color = <?= $messageType === 'success' ? '"#155724"' : '"#721c24"' ?>;
        alertBox.style.border = <?= $messageType === 'success' ? '"1px solid #c3e6cb"' : '"1px solid #f5c6cb"' ?>;

        

        // Auto-hide after 3 seconds
        setTimeout(() => {
            alertBox.style.display = "none";
        }, 3000);
        // Remove query string (e.g., ?msg=success) from URL
        if (window.history.replaceState) {
            const cleanUrl = window.location.protocol + "//" + window.location.host + window.location.pathname;
            window.history.replaceState({}, document.title, cleanUrl);
        }
    <?php endif; ?>
</script>  
</body>
</html>
