function openAnswerModal(record) {
  document.getElementById("answerSessionId").innerText = record.session_id;

  const tbody = document.querySelector("#answerTableBody");
  tbody.innerHTML = "<tr><td colspan='4'>Loading...</td></tr>";

  fetch("user_index.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: "fetch_winners=1&session_id=" + record.session_id,
  })
    .then((res) => res.json())
    .then((data) => {
      tbody.innerHTML = "";
      if (data.length > 0) {
        data.forEach((q) => {
          const tr = document.createElement("tr");
          tr.innerHTML = `
            <td>${q.question_id}</td>
            <td>${q.winner_name ?? "Unknown"} / ${q.winner_id}</td>
            <td>${q.timestamp_ms} ms</td>
            <td>${q.created_at}</td>
            <td class="sticky-col" style="background-color:#f0efff;">
                <a href="#" 
                    onclick='openEachuserAnswerModal(${q.quiz_id}, ${
            q.question_id
          }, ${q.session_id}); return false;'>
                    <img src="./icons/view.png" alt="View Answers" style="width:18px; height:18px;">
                </a>
            </td>
          `;
          tbody.appendChild(tr);
        });
      } else {
        tbody.innerHTML = `<tr><td colspan="4">No winners found.</td></tr>`;
      }
    });

  showModal("answerModal");
}

function closeModal() {
  document.getElementById("answerModal").style.display = "none";
}
function closeModalSecond() {
  document.getElementById("userAnswerModal").style.display = "none";
}

function showModal(id) {
  document.getElementById(id).style.display = "block";
}

function openEachuserAnswerModal(quizId, questionId, quizRecordId) {
  const tbody = document.querySelector("#userAnswerTableBody");
  tbody.innerHTML = "<tr><td colspan='6'>Loading...</td></tr>";

  fetch("user_index.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `fetch_question_answers=1&quiz_id=${quizId}&question_id=${questionId}&quiz_record_id=${quizRecordId}`,
  })
    .then((res) => res.json())
    .then((data) => {
      tbody.innerHTML = "";
      if (data.length > 0) {
        data.forEach((a) => {
          const tr = document.createElement("tr");
          tr.innerHTML = `
            <td>${a.username} / ${a.user_id}</td>
            <td>${a.question_text}</td>
            <td>${a.answer_text}</td>
            <td class="${a.is_correct ? "correct" : "wrong"}">
              ${a.is_correct ? "Correct" : "Wrong"}
            </td>
            <td>${a.time_taken_ms ?? "-"} ms</td>
            <td>${a.answer_at_ms}</td>
          `;
          tbody.appendChild(tr);
        });
      } else {
        tbody.innerHTML = `<tr><td colspan="6">No answers found.</td></tr>`;
      }
    });

  showModal("userAnswerModal");
}
