// --- Open Answer Modal for a Quiz Record ---
function openAnswerModal(record) {
  document.getElementById("answerSessionId").innerText = record.session_id;

  const tbody = document.querySelector("#answerTableBody");
  tbody.innerHTML = "<tr><td colspan='4'>Loading...</td></tr>";

  fetch("quiz_index.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: "fetch_answers=1&session_id=" + record.session_id,
  })
    .then((res) => res.json())
    .then((data) => {
      tbody.innerHTML = "";
      if (data.length > 0) {
        data.forEach((a) => {
          const tr = document.createElement("tr");
          tr.innerHTML = `
            <td>${a.answered_at ?? "-"}</td>
            <td>${a.username} / ${a.user_id}</td>
            <td>${a.answer_text ?? "Not Answered"}</td>
            <td class="${
              a.is_correct === null
                ? "wrong"
                : a.is_correct
                ? "correct"
                : "wrong"
            }">
              ${
                a.is_correct === null
                  ? "Not Answered"
                  : a.is_correct
                  ? "Correct"
                  : "Wrong"
              }
            </td>
          `;
          tbody.appendChild(tr);
        });
      } else {
        tbody.innerHTML = `<tr><td colspan="4">No users found.</td></tr>`;
      }
    });

  showModal("answerModal");
}
// --- Edit fuction for  Quiz and Quiz Question list ---
function openEditQuiz(quiz) {
  fetch("quiz_index.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: "fetch_full_quiz=1&quiz_id=" + quiz.id,
  })
    .then((res) => res.json())
    .then((fullQuiz) => {
      // Fill form inputs (only what exists in schema!)
      document.getElementById("edit_quiz_id").value = fullQuiz.id;
      document.getElementById("edit_quiz_category").value =
        fullQuiz.category_id;
      document.getElementById("edit_quiz_language").value =
        fullQuiz.language_id;

      // Fill questions
      const container = document.getElementById("editQuestionsList");
      container.innerHTML = "";
      fullQuiz.questions.forEach((q, index) => {
        container.innerHTML += `
          <div style="margin-bottom:10px; border:1px solid #ccc; padding:10px;">
            
            <label>Question ${index + 1}:
              <input type="text" class="custom-input" name="questions[${
                q.id
              }][text]" value="${q.question_text}">
            </label><br><br>

            <label>Answer Type:
              <select class="custom-input" name="questions[${q.id}][type]">
                <option value="mcq" ${
                  q.answer_type === "mcq" ? "selected" : ""
                }>MCQ</option>
                <option value="true_false" ${
                  q.answer_type === "true_false" ? "selected" : ""
                }>True/False</option>
              </select>
            </label><br><br>

            <label>Options:
              <input type="text" class="custom-input" name="questions[${
                q.id
              }][options]" value="${q.options?.join(",") || ""}">
            </label><br><br>

            <label>Correct Answer:
              <input type="text" class="custom-input" name="questions[${
                q.id
              }][answer]" value="${q.correct_answer}">
            </label>
          </div>
        `;
      });

      showModal("editQuizModal");
    })
    .catch((err) => console.error("Error fetching quiz:", err));
}
// --- Modal Helper Functions ---
function showModal(id) {
  document.getElementById(id).style.display = "block";
}
function closeModal() {
  const modals = document.querySelectorAll(
    "#answerModal, #addQuizModal, #editQuizModal, #deleteQuizModal, #viewQuestionsModal"
  );

  modals.forEach((m) => {
    if (m.style.display !== "none") {
      m.style.display = "none";

      // reload only if it's addQuizModal
      if (m.id === "viewQuestionsModal") {
        location.reload();
      }
    }
  });
}

//---------------------------------------------------------Quiz Question View---------------------------------------------------------------------------------
let currentQuizId = null;
//view function display.
function openQuestinoModal(quiz) {
  currentQuizId = quiz.id; // <-- store quiz id globally
  fetch("quiz_index.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: "fetch_questions=1&quiz_id=" + quiz.id,
  })
    .then((res) => res.json())
    .then((data) => {
      const tbody = document.getElementById("questionsTableBody");
      tbody.innerHTML = "";

      if (data.length === 0) {
        tbody.innerHTML =
          "<tr><td colspan='6' style='text-align:center;'>No questions found</td></tr>";
      } else {
        data.forEach((q, index) => {
          const tr = document.createElement("tr");
          tr.innerHTML = `
            <td>${q.id}</td>
            <td>${q.question_text}</td>
            <td>${q.answer_type}</td>
            <td>${
              q.options && q.options.length ? q.options.join(", ") : "-"
            }</td>
            <td>${q.correct_answer}</td>
            <td>
              <button type="button" onclick="deleteQuestion(${q.id}, ${
            quiz.id
          })" style="border:none; background:none; padding:4px; cursor:pointer;"><img src="./icons/delete.png" alt="delete" style="width:18px; height:18px;"></button>
            </td>
          `;
          tbody.appendChild(tr);
        });
      }

      showModal("viewQuestionsModal");
    })
    .catch((err) => console.error("Error fetching questions:", err));
}
// Add New Question button
document.getElementById("addQuestionViewBtn").addEventListener("click", () => {
  const tbody = document.getElementById("questionsTableBody");
  const newRowId = "new_" + (tbody.children.length + 1);

  const tr = document.createElement("tr");
  tr.innerHTML = `
        <td>New</td>
        <td><input type="text" name="questions[${newRowId}][text]"></td>
        <td>
            <select name="questions[${newRowId}][type]">
                <option value="mcq">MCQ</option>
                <option value="true_false">True/False</option>
            </select>
        </td>
        <td><input type="text" name="questions[${newRowId}][options]"></td>
        <td><input type="text" name="questions[${newRowId}][answer]"></td>
        <td>
            <button type="button" id="saveNewQuestionsBtn" style="margin-top:10px;">Save </button>

        </td>
    `;

  tbody.prepend(tr); // adds at the top
});
// delegate clicks from tbody
document.getElementById("questionsTableBody").addEventListener("click", (e) => {
  if (e.target && e.target.id === "saveNewQuestionsBtn") {
    saveNewQuestions();
  }
});

// move your save logic into a function
function saveNewQuestions() {
  const tbody = document.getElementById("questionsTableBody");
  const newQuestions = [];

  tbody.querySelectorAll("tr").forEach((tr) => {
    if (tr.cells[0].innerText === "New") {
      const text = tr.querySelector("input[name*='[text]']").value.trim();
      const type = tr.querySelector("select[name*='[type]']").value;
      const options = tr.querySelector("input[name*='[options]']").value.trim();
      const answer = tr.querySelector("input[name*='[answer]']").value.trim();

      if (text !== "") {
        newQuestions.push({ text, type, options, answer });
      }
    }
  });

  if (newQuestions.length === 0) {
    alert("No new questions to save.");
    return;
  }

  fetch("quiz_index.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({
      quiz_id: currentQuizId,
      new_questions: newQuestions,
    }),
  })
    .then((res) => res.json())
    .then((data) => {
      if (data.success) {
        alert("New questions added!");
        openQuestinoModal({ id: currentQuizId }); // reload table
      } else {
        alert("Error adding questions.");
      }
    })
    .catch((err) => console.error(err));
}

// Function to delete existing question (calls backend) inside quize
function deleteQuestion(questionId, quizId) {
  if (!confirm("Are you sure you want to delete this question?")) return;

  fetch("quiz_index.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `delete_question_id=${questionId}&quiz_id=${quizId}`,
  })
    .then((res) => res.json())
    .then((data) => {
      if (data.success) {
        alert("Question deleted");
        // remove from table
        openQuestinoModal(data.quiz); // re-render updated quiz
      } else {
        alert("Error deleting question");
      }
    })
    .catch((err) => console.error(err));
}
//-----------------------------------------------Add new quiz-------------------------------------------------------------------
let addQuestionCounter = 0; // counter for unique input names
// --- Add Quiz Modal ---
function openAddQuizModal() {
  showModal("addQuizModal");
}
function openAddQuizModal() {
  document.getElementById("addQuestionsList").innerHTML = ""; // clear old questions
  addQuestionCounter = 0;

  showModal("addQuizModal"); // simply show the modal
}
// Add new question dynamically
document.getElementById("addNewQuestionBtn").addEventListener("click", () => {
  addQuestionCounter++;
  const container = document.getElementById("addQuestionsList");

  const div = document.createElement("div");
  div.classList.add("question-block");
  div.style = "margin-bottom:15px; border:1px solid #ccc; padding:10px;";

  div.innerHTML = `
        <label>Question:
            <input type="text" class="custom-input" name="questions[${addQuestionCounter}][text]" required>
        </label><br><br>
        <label>Answer Type:
            <select class="custom-input" name="questions[${addQuestionCounter}][type]" required>
                <option value="mcq">MCQ</option>
                <option value="true_false">True/False</option>
            </select>
        </label><br><br>
        <label>Options (comma separated):
            <input type="text" class="custom-input" name="questions[${addQuestionCounter}][options]">
        </label><br><br>
        <label>Correct Answer:
            <input type="text" class="custom-input" name="questions[${addQuestionCounter}][answer]" required>
        </label><br><br>
        <button type="button" onclick="this.parentElement.remove()" style="border:none; background:none; padding:4px; cursor:pointer;"><img src="./icons/delete.png" alt="delete" style="width:18px; height:18px;"></button>
    `;
  container.appendChild(div);
});
//------------------------------------------------------------------------------------------------------------------------------
//edit fuction of question list
function renderQuestions(questions) {
  const qList = document.getElementById("quizQuestionsList");
  qList.innerHTML = "";

  questions.forEach((q) => {
    addQuestionBlock(q);
  });

  if (questions.length === 0) {
    addQuestionBlock(); // show at least one empty block
  }
}
//-----------------------------------------Add New Category module--------------------------------------------------------------------------------------------
document.getElementById("saveCategoryBtn").addEventListener("click", () => {
  const name = document.getElementById("newCategoryName").value.trim();
  const msgDiv = document.getElementById("categoryMessage");
  msgDiv.innerText = "";

  if (!name) return alert("Please enter a category name.");

  fetch("quiz_index.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ new_category: name }),
  })
    .then((res) => res.json())
    .then((data) => {
      if (data.success) {
        msgDiv.style.color = "green";
        msgDiv.innerText = `Category "${data.name}" added successfully!`;
        document.getElementById("newCategoryName").value = "";

        // Optional: add to any category dropdowns dynamically
        const selects = document.querySelectorAll("select[name='category_id']");
        selects.forEach((select) => {
          const opt = document.createElement("option");
          opt.value = data.id;
          opt.text = data.name;
          select.appendChild(opt);
        });
      } else {
        msgDiv.style.color = "red";
        msgDiv.innerText = data.error;
      }
    })
    .catch((err) => console.error(err));
});

//-----------------------------------------Add New language module--------------------------------------------------------------------------------------------
document.getElementById("savelanguageBtn").addEventListener("click", () => {
  const name = document.getElementById("newlanguageName").value.trim();
  const msgDiv = document.getElementById("languageMessage");
  msgDiv.innerText = "";

  if (!name) return alert("Please enter a language name.");

  fetch("quiz_index.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ new_language: name }),
  })
    .then((res) => res.json())
    .then((data) => {
      if (data.success) {
        msgDiv.style.color = "green";
        msgDiv.innerText = `language "${data.name}" added successfully!`;
        document.getElementById("newlanguageName").value = "";

        // Optional: add to any category dropdowns dynamically
        const selects = document.querySelectorAll("select[name='language_id']");
        selects.forEach((select) => {
          const opt = document.createElement("option");
          opt.value = data.id;
          opt.text = data.name;
          select.appendChild(opt);
        });
      } else {
        msgDiv.style.color = "red";
        msgDiv.innerText = data.error;
      }
    })
    .catch((err) => console.error(err));
});
//--------------------------------toggle button-------------------------------------------------------------------------------------------------------------
function toggleDiv(id) {
  const el = document.getElementById(id);
  el.style.display =
    el.style.display === "none" || el.style.display === "" ? "block" : "none";
}
