<?php
// Database configuration

$host = '43.156.107.139:3306';
$dbUser = 'app';
$dbPass = 'tsWCsDatPp2FYRaZ';
$dbName = 'app';

// Create connection
$conn = mysqli_connect($host, $dbUser, $dbPass, $dbName);

// Check connection
if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}
//------------------------------------------------------------Qize List Page Functiob---------------------------------------------------------------------
// Fetch all quizzes
function getAllQuizzes() {
    global $conn;

    $sql = "
        SELECT 
            q.id, 
            q.name,
            q.created_at, 
            q.updated_at, 
            c.name AS category_name, 
            l.name AS language_name,
            COUNT(ques.id) AS question_count
        FROM bogo_quiz_quizzes q
        JOIN bogo_quiz_categories c ON q.category_id = c.id
        JOIN bogo_quiz_language l ON q.language_id = l.id
        LEFT JOIN bogo_quiz_questions ques ON q.id = ques.quiz_id
        GROUP BY q.id, c.name, l.name
        ORDER BY q.created_at DESC;

    ";

    $result = mysqli_query($conn, $sql);
    $quizzes = [];
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $quizzes[] = $row;
        }
    }
    return $quizzes;
}
// Fetch all quiz sessions (records) with user/id combo
function getAllQuizRecords() {
    global $conn;
    $sql = "SELECT 
                qr.id AS session_id,
                qr.live_id,
                qr.started_at AS session_start,
                qr.ended_at AS session_end,
                CONCAT(u.nick_name, '/', u.id) AS started_by_user,
                ql.quiz_title,
                ql.question_text,
                ql.answer_type,
                ql.options,
                ql.correct_answer,
                qr.winner_id AS winner_id,
                CONCAT(uw.username, '/', uw.id) AS winner_display
            FROM bogo_quiz_record qr
            LEFT JOIN bogo_user u 
                   ON qr.started_by = u.id
            LEFT JOIN bogo_quiz_list ql 
                   ON qr.quiz_id = ql.id
            LEFT JOIN bogo_user uw 
                   ON qr.winner_id = uw.id
            ORDER BY qr.started_at DESC, session_id, ql.id";

    $result = mysqli_query($conn, $sql);

    $records = [];
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $records[] = $row;
        }
    }
    return $records;
}
// fetch the lsit of category
function getAllCategories() {
    global $conn;
    $categories = [];
    $result = $conn->query("SELECT id, name FROM bogo_quiz_categories ORDER BY name ASC");
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }
    return $categories;
}
// fetch the lsit of language
function getAlllanguages() {
    global $conn;
    $languages = [];
    $result = $conn->query("SELECT id, name FROM bogo_quiz_language ORDER BY name ASC");
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }
    return $categories;
}

//update quize
function addQuiz($conn, $data) {
    // Insert into quizzes
    $sql = "INSERT INTO quizzes (name, category_id, language_id, created_at, updated_at) 
            VALUES (?,?,?, NOW(), NOW())";
    $stmt = $conn->prepare($sql);
     $stmt->bind_param("sii", $data['name'], $data['category_id'], $data['language_id']);
    $stmt->execute();
    $quizId = $conn->insert_id;

    // Insert first question (if provided)
    if (!empty($data['question_text'])) {
        $options = !empty($data['options']) ? json_encode(explode(',', $data['options'])) : json_encode([]);
        $sql2 = "INSERT INTO bogo_quiz_questions 
                 (quiz_id, question_text, answer_type, options, correct_answer) 
                 VALUES (?, ?, ?, ?, ?)";
        $stmt2 = $conn->prepare($sql2);
        $stmt2->bind_param(
            "issss",
            $quizId,
            $data['question_text'],
            $data['answer_type'],
            $options,
            $data['correct_answer']
        );
        $stmt2->execute();
    }

    return $quizId;
}
// Get only questions for a quiz
function getQuestionsByQuiz($quizId) {
    global $conn;
    $sql = "SELECT id, question_text, answer_type, options, correct_answer
            FROM bogo_quiz_questions
            WHERE quiz_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $quizId);
    $stmt->execute();
    $result = $stmt->get_result();

    $questions = [];
    while ($row = $result->fetch_assoc()) {
        $row['options'] = $row['options'] ? json_decode($row['options'], true) : [];
        $questions[] = $row;
    }
    return $questions;
}
// Get quiz with its questions
function getQuizById($quizId) {
    global $conn;

    $sql = "SELECT q.id, 
                   q.category_id, 
                   c.name AS category_name,
                   q.language_id,
                   l.name AS language_name,
                   q.created_at, 
                   q.updated_at
            FROM bogo_quiz_quizzes q
            JOIN bogo_quiz_categories c ON q.category_id = c.id
            JOIN bogo_quiz_language l ON q.language_id = l.id
            WHERE q.id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $quizId);
    $stmt->execute();
    $quizResult = $stmt->get_result()->fetch_assoc();

    if (!$quizResult) {
        return [];
    }

    $sql2 = "SELECT id, question_text, answer_type, options, correct_answer
             FROM bogo_quiz_questions
             WHERE quiz_id = ?";
    $stmt2 = $conn->prepare($sql2);
    $stmt2->bind_param("i", $quizId);
    $stmt2->execute();
    $questionsResult = $stmt2->get_result()->fetch_all(MYSQLI_ASSOC);

    foreach ($questionsResult as &$q) {
        $q['options'] = $q['options'] ? json_decode($q['options'], true) : [];
    }

    $quizResult['questions'] = $questionsResult;
    return $quizResult;
}


//------------------------------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------User Page Details fucntion--------------------------------------------------------------------------------------------

function getAllQuizSessions() {
    global $conn;

    $sql = "
        SELECT 
            qr.session_id,
            qr.live_id,
            qr.quiz_id,
            qr.started_at AS session_start,
            qr.ended_at AS session_end,

            u.id AS started_by_user_id,
            u.nick_name AS started_by_user,

            c.name AS category,
            l.name AS language,

            COUNT(DISTINCT qar.question_id) AS no_questions,
            qr.winner_id
        FROM bogo_quiz_record qr
        LEFT JOIN bogo_user u 
            ON qr.started_by = u.id
        LEFT JOIN bogo_quiz_quizzes q 
            ON qr.quiz_id = q.id
        LEFT JOIN bogo_quiz_categories c 
            ON q.category_id = c.id
        LEFT JOIN bogo_quiz_language l 
            ON q.language_id = l.id
        LEFT JOIN bogo_quiz_answer_record qar 
            ON qr.session_id = qar.session_id
        GROUP BY 
            qr.session_id,
            qr.live_id,
            qr.quiz_id,
            qr.started_at,
            qr.ended_at,
            u.id, u.nick_name,
            c.name,
            l.name,
            qr.winner_id
        ORDER BY qr.started_at DESC
    ";

    $result = mysqli_query($conn, $sql);
    $records = [];
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $records[] = $row;
        }
    }
    return $records;
}


function getQuestionWinnersBySession($sessionId) {
    global $conn;

    $sql = "
        SELECT 
            qwl.id,
            qwl.session_id,
            qwl.quiz_id,
            qwl.question_id,
            qwl.winner_id,
            u.nick_name AS winner_name,
            qwl.timestamp_ms,
            qwl.created_at
        FROM bogo_quiz_question_winnerlist qwl
        LEFT JOIN bogo_user u ON qwl.winner_id = u.id
        WHERE qwl.session_id = " . intval($sessionId) . "
        ORDER BY qwl.question_id ASC
    ";

    $result = mysqli_query($conn, $sql);
    $winners = [];
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $winners[] = $row;
        }
    }
    return $winners;
}

function getAnswersForQuestion($quizId, $questionId, $quizRecordId) {
    global $conn;

    $sql = "
        SELECT 
            ar.user_id,
            u.nick_name,
            q.question_text,
            ar.answer_text,
            ar.is_correct,
            ar.answer_at_ms,
            (ar.answer_at_ms - ar.question_start_ms) AS time_taken_ms,
            ar.question_start_ms,
            ar.question_end_ms
        FROM bogo_quiz_answer_record ar
        LEFT JOIN bogo_user u 
            ON ar.user_id = u.id
        LEFT JOIN bogo_quiz_questions q 
            ON ar.question_id = q.id
        WHERE ar.quiz_id = $quizId
          AND ar.question_id = $questionId
          AND ar.session_id = $quizRecordId
        ORDER BY ar.is_correct DESC, time_taken_ms ASC
    ";

    $result = mysqli_query($conn, $sql);
    $answers = [];
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $answers[] = $row;
        }
    }
    return $answers;
}


?>